<? if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();
/** @var array $arParams */
/** @var array $arResult */
/** @global CMain $APPLICATION */
/** @global CUser $USER */
/** @global CDatabase $DB */
/** @var CBitrixComponentTemplate $this */
/** @var string $templateName */
/** @var string $templateFile */
/** @var string $templateFolder */
/** @var string $componentPath */
/** @var CBitrixComponent $component */
$this->setFrameMode(true);
echo "<pre>";
print_r($arResult["DIRECTIONS"]);
echo "</pre>";

?>

<section class="page-section page-section--p-t-header">
        <div class="hero hero--about-us-research-center" data-animate="hero-block">
            <div class="container container--no-p">
                <div class="hero__inner">
                    <div class="hero__bg">
                        <div class="hero__bg-gradient">
                            <?
                            $bg1921 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['BG_1921']["VALUE"]);
                            $bg768 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['BG_768']["VALUE"]);
                            $bg767 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['BG_767']["VALUE"]);

                            ?>
                            <picture>
                                <source media="(min-width: 1921px)"
                                        srcset="<?= $bg1921 ?>"
                                        type="image/webp">
                                <source media="(min-width: 768px)"
                                        srcset="<?= $bg768 ?>"
                                        type="image/webp">
                                <source media="(max-width: 767px)"
                                        srcset="<?= $bg767 ?>"
                                        type="image/webp">
                                <img src="<?= $arResult['BANNER']["PREVIEW_PICTURE"]["SRC"] ?>"
                                     srcset="<?= $arResult['BANNER']["PREVIEW_PICTURE"]["SRC"] ?>"
                                     alt="Изображение" width="1512" height="744" loading="lazy">
                            </picture>
                        </div>
                    </div>
                    <div class="hero__bg-pixels hero__bg-pixels--t-l" data-pixels="hero-solutions-t-l"
                         data-pixels-qty="84">

                    </div>
                    <div class="hero__bg-pixels hero__bg-pixels--b-r" data-pixels="hero-solutions-b-r"
                         data-pixels-qty="72">

                    </div>
                    <div class="hero__container">
                        <div class="breadcrumbs hero__breadcrumbs swiper-backface-hidden swiper-initialized swiper-horizontal swiper-free-mode">
                            <ol class="breadcrumbs__list">
                                <li class="breadcrumbs__item swiper-slide-active" style="margin-right: 24px;">
                                    <a href="/" class="breadcrumbs__link">

                                        <span class="breadcrumbs__link-text">Главная</span>

                                    </a>
                                </li>
                                <li class="breadcrumbs__item swiper-slide-next" style="margin-right: 24px;">
          <span class="breadcrumbs__link breadcrumbs__link--current">

            <span class="breadcrumbs__link-text">Исследовательский центр</span>

</span>
                                </li>
                            </ol>
                        </div>
                        <div class="hero__img" data-animate="hero-image-d-index" style="">

                            <?
                            $img1921 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['IMG_1921']["VALUE"]);
                            $img768 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['IMG_768']["VALUE"]);
                            $img767 = CFile::GetPath($arResult['BANNER']["PROPERTIES"]['IMG_767']["VALUE"]);

                            ?>
                            <picture>
                                <source media="(min-width: 1921px)"
                                        srcset="<?= $img1921 ?>"
                                        type="image/webp">
                                <source media="(min-width: 768px)"
                                        srcset="<?= $img768 ?>"
                                        type="image/webp">
                                <source media="(max-width: 767px)"
                                        srcset="<?= $img767 ?>"
                                        type="image/webp">
                                <img src="<?= $arResult['BANNER']["DETAIL_PICTURE"]["SRC"] ?>"
                                     srcset="<?= $arResult['BANNER']["DETAIL_PICTURE"]["SRC"] ?>"
                                     alt="Изображение" width="1376" height="1376" loading="lazy">
                            </picture>

                        </div>
                        <div class="hero__text-wrap">
                            <div class="hero__title-description-wrap">
                                <h1 class="title title--h1
                                hero__title"><?=$arResult['BANNER']['PROPERTIES']["TITLE"]['~VALUE']['TEXT']?></h1>
                                <p class="hero__text"><?= $arResult['BANNER']["PREVIEW_TEXT"] ?></p>

                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>

    </section>
    <div class="product-header" data-product-header="header">
        <div class="product-header__wrap">
            <div class="container">

                <div class="product-header__line"
                     style="translate: none; rotate: none; scale: none; transform: translate(-100%, 0%);"></div>
                <div class="product-header__inner" data-product-header="inner">
                    <div class="product-header__icon product-header__icon--data">
                        <svg width="1em" height="1em" viewBox="0 0 32 32" data-icon="icon-data-pk">

                            <symbol id="ai:local:icon-data-pk">
                                <g fill="none" stroke-width="1.5">
                                    <path stroke="#0B2027" stroke-linecap="round" stroke-linejoin="round"
                                          d="M16.102 29.334a2.424 2.424 0 0 1-2.424-2.425V26.8a1.999 1.999 0 0 0-1.31-1.83 2 2 0 0 0-2.205.4l-.073.073a2.427 2.427 0 1 1-3.43-3.43l.072-.073a2 2 0 0 0 .4-2.206 2 2 0 0 0-1.83-1.213h-.206a2.424 2.424 0 1 1 0-4.848h.11a2 2 0 0 0 1.83-1.309 2 2 0 0 0-.4-2.206l-.073-.073a2.425 2.425 0 1 1 3.43-3.43l.073.073a2 2 0 0 0 2.206.4h.097a2 2 0 0 0 1.212-1.83V5.09a2.424 2.424 0 0 1 2.424-2.424"></path>
                                    <path stroke="#00D29D"
                                          d="M19.146 16a3.546 3.546 0 1 1-7.093 0 3.546 3.546 0 0 1 7.092 0Z"></path>
                                    <circle cx="27.416" cy="16.001" r="2.472" stroke="#00D29D"></circle>
                                    <circle cx="25.259" cy="6.334" r="2.472" stroke="#00D29D"></circle>
                                    <circle cx="25.259" cy="25.668" r="2.472" stroke="#00D29D"></circle>
                                    <path stroke="#00D29D" stroke-linecap="round"
                                          d="m18.818 12.778 4.297-4.297m-4.297 10.741 4.297 4.297M18.818 16h6.445"></path>
                                </g>
                            </symbol>
                            <use xlink:href="#ai:local:icon-data-pk"></use>

                        </svg>
                    </div>
                    <button class="product-header__active-btn" data-product-header="active-btn" type="button">
                        работа
                    </button>
                    <div class="product-header__icon product-header__icon--dropdown">
                        <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="icon-chevron-down">

                            <use xlink:href="#ai:local:icon-chevron-down"></use>

                        </svg>
                    </div>

                    <div class="product-header__list-wrap swiper swiper-backface-hidden swiper-initialized swiper-horizontal swiper-free-mode"
                         data-product-header-slider="container">
                        <ul class="product-header__list swiper-wrapper">
                            <li class="product-header__item swiper-slide swiper-slide-active"
                                style="margin-right: 16px;">
                                <a class="product-header__link" href="#work" data-navigation-link="">
                                    работа
                                </a>
                            </li>
                            <li class="product-header__item swiper-slide swiper-slide-next" style="margin-right: 16px;">
                                <a class="product-header__link" href="#research" data-navigation-link="">
                                    исследования
                                </a>
                            </li>
                            <li class="product-header__item swiper-slide" style="margin-right: 16px;">
                                <a class="product-header__link" href="#cooperations" data-navigation-link="">
                                    сотрудничество
                                </a>
                            </li>
                            <li class="product-header__item swiper-slide" style="margin-right: 16px;">
                                <a class="product-header__link" href="#team" data-navigation-link="">
                                    команда
                                </a>
                            </li>
                            <li class="product-header__item swiper-slide" style="margin-right: 16px;">
                                <a class="product-header__link" href="#links" data-navigation-link="">
                                    ссылки
                                </a>
                            </li>
                            <li class="product-header__item swiper-slide" style="margin-right: 16px;">
                                <a class="product-header__link" href="#events" data-navigation-link="">
                                    события
                                </a>
                            </li>
                        </ul>
                    </div>
                    <button class="button product-header__btn"><span class="button__text">запросить демо</span><span
                                class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></button>
                </div>

            </div>
        </div>
    </div>
    <section class="page-section page-section--no-pt" id="work">

        <div class="work-vector">
            <div class="container">

                <div class="work-vector__inner">
                    <div class="work-vector__aside">
                        <div class="section-title work-vector__title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">работа</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 2; --line-total: 2;">направления работы</h2>
                            </div>

                        </div>

                    </div>
                    <div class="work-vector__main">
                        <ul class="work-vector__list">
                            <? foreach ($arResult["DIRECTIONS"] as $item){
                                ?>
                                <li class="work-vector__item">
                                <div class="research-card research-card--green">
                                    <div class="research-card__bg">
                                        <div class="research-card__bg-image">
                                            <picture>
                                                <source media="(min-width: 1921px)"
                                                        srcset="<?=SITE_TEMPLATE_PATH?>/images/bg/bg-research-card-green-xl.webp,
                                                        <?=SITE_TEMPLATE_PATH?>/images/bg/bg-research-card-green-xl@2x.webp 2x, <?=SITE_TEMPLATE_PATH?>/images/bg/bg-research-card-green-xl@3x.webp 3x"
                                                        type="image/webp">
                                                <source media="(min-width: 768px)"
                                                        srcset="./images/bg/bg-research-card-green-d.webp, ./images/bg/bg-research-card-green-d@2x.webp 2x, ./images/bg/bg-research-card-green-d@3x.webp 3x"
                                                        type="image/webp">
                                                <source media="(max-width: 767px)"
                                                        srcset="./images/bg/bg-research-card-green.webp, ./images/bg/bg-research-card-green@2x.webp 2x, ./images/bg/bg-research-card-green@3x.webp 3x"
                                                        type="image/webp">
                                                <img src="./images/bg/bg-research-card-green.png"
                                                     srcset="./images/bg/bg-research-card-green@2x.png 2x, ./images/bg/bg-research-card-green@3x.png 3x"
                                                     alt="Картинка" width="1345" height="541" loading="lazy">
                                            </picture>

                                        </div>
                                        <div class="research-card__bg-pixels" data-pixels="research-card"
                                             data-pixels-qty="39">
                                        </div>
                                    </div>
                                    <div class="research-card__inner">
    <span class="research-card__icon">
      <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="card-indicator">

  <symbol id="ai:local:card-indicator"><g fill="none"><rect width="17" height="17" x=".5" y=".5" stroke="currentColor"
                                                            rx="4.5"></rect><rect width="12" height="12" x="3" y="3"
                                                                                  fill="currentColor" rx="2"></rect></g></symbol><use
                  xlink:href="#ai:local:card-indicator"></use>

</svg>
    </span>
                                        <h3 class="research-card__title">Исследования</h3>
                                        <p class="research-card__text">Генерация и&nbsp;проверка научных гипотез, анализ
                                            лучших практик, проведение экспериментов, формирование и&nbsp;поддержание в&nbsp;актуальном
                                            состоянии базы знаний и&nbsp;инструментов, написание научных статей.</p>
                                    </div>
                                </div>
                            </li>
                            <?}?>
                        </ul>
                        <div class="work-vector__hash-wrap dynamic-adaptive"
                             data-da-max=".work-vector__main, 767, last">
                            <b class="work-vector__hash-counter">5</b>
                            <p class="work-vector__hash-title">Направлений работы</p>
                            <p class="work-vector__hash-description">
                                Используем лучшие практики в&nbsp;отрасли и&nbsp;проводим обучение
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </section>
    <section class="page-section page-section--no-pt page-section--pt-mob" id="research">

        <div class="advantages-solutions advantages-solutions--wide-title">
            <div class="advantages-solutions__wrap" style="">
                <div class="container advantages-solutions__container">

                    <div class="advantages-solutions__inner">
                        <div class="advantages-solutions__header">
                            <div class="section-title">
                                <div class="section-title__wrap">
                                    <p class="section-title__badge">исследования</p>
                                    <h2 data-animate="title"
                                        class="title title--h2 section-title__title words lines splitting is-show"
                                        style="--word-total: 2; --line-total: 1;"><span class="word"
                                                                                        data-word="направления"
                                                                                        style="--word-index: 0; --line-index: 0;"><span
                                                    class="word-inner">направления</span></span><span
                                                class="whitespace"> </span><span class="word" data-word="исследований"
                                                                                 style="--word-index: 1; --line-index: 0;"><span
                                                    class="word-inner">исследований</span></span></h2>
                                </div>

                            </div>
                        </div>
                        <div class="advantages-solutions__content">
                            <ul class="advantages-solutions__list"
                                style="translate: none; rotate: none; scale: none; transform: translate(0px, 0px);">
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <symbol id="ai:local:icon-plus">
                                                            <path fill="none" stroke="currentColor"
                                                                  d="M7.5 0v15M0 7.5h15"></path>
                                                        </symbol>
                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/benefit-analytic-xl.webp, ./images/benefit/benefit-analytic-xl@2x.webp 2x, ./images/benefit/benefit-analytic-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/benefit-analytic-d.webp, ./images/benefit/benefit-analytic-d@2x.webp 2x, ./images/benefit/benefit-analytic-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/benefit-analytic.webp, ./images/benefit/benefit-analytic@2x.webp 2x, ./images/benefit/benefit-analytic@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/benefit-analytic.png"
                                                         srcset="./images/benefit/benefit-analytic@2x.png 2x, ./images/benefit/benefit-analytic@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">01</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Предиктивная аналитика</h3>
                                            <div class="benefit-plate__text">
                                                <p>Временные ряды, нейросети, прогнозирование, поиск и&nbsp;объяснение
                                                    аномалий, обнаружение паттернов, определение режимов работы, анализ
                                                    корневых причин событий, визуализация.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/nlp-xl.webp, ./images/benefit/nlp-xl@2x.webp 2x, ./images/benefit/nlp-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/nlp-d.webp, ./images/benefit/nlp-d@2x.webp 2x, ./images/benefit/nlp-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/nlp.webp, ./images/benefit/nlp@2x.webp 2x, ./images/benefit/nlp@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/nlp.png"
                                                         srcset="./images/benefit/nlp@2x.png 2x, ./images/benefit/nlp@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">02</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Распознавание естественного языка
                                                (NLP)</h3>
                                            <div class="benefit-plate__text">
                                                <p>Семантический анализ документов, базы знаний и&nbsp;онтологии,
                                                    автоматизация документооборота.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/monitor-xl.webp, ./images/benefit/monitor-xl@2x.webp 2x, ./images/benefit/monitor-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/monitor-d.webp, ./images/benefit/monitor-d@2x.webp 2x, ./images/benefit/monitor-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/monitor.webp, ./images/benefit/monitor@2x.webp 2x, ./images/benefit/monitor@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/monitor.png"
                                                         srcset="./images/benefit/monitor@2x.png 2x, ./images/benefit/monitor@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">03</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Компьютерное (машинное) зрение</h3>
                                            <div class="benefit-plate__text">
                                                <p>Распознавание контента и&nbsp;типа документов, автоматизация
                                                    документооборота.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/benefit-security-xl.webp, ./images/benefit/benefit-security-xl@2x.webp 2x, ./images/benefit/benefit-security-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/benefit-security-d.webp, ./images/benefit/benefit-security-d@2x.webp 2x, ./images/benefit/benefit-security-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/benefit-security.webp, ./images/benefit/benefit-security@2x.webp 2x, ./images/benefit/benefit-security@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/benefit-security.png"
                                                         srcset="./images/benefit/benefit-security@2x.png 2x, ./images/benefit/benefit-security@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">04</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Информационная безопасность</h3>
                                            <div class="benefit-plate__text">
                                                <p>Анализ сетевого трафика и&nbsp;взаимодействия сетевых элементов,
                                                    обнаружение признаков злонамеренных действий, автоматизация
                                                    реагирования, применение методов искусственного интеллекта в&nbsp;ИБ.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/llm-xl.webp, ./images/benefit/llm-xl@2x.webp 2x, ./images/benefit/llm-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/llm-d.webp, ./images/benefit/llm-d@2x.webp 2x, ./images/benefit/llm-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/llm.webp, ./images/benefit/llm@2x.webp 2x, ./images/benefit/llm@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/llm.png"
                                                         srcset="./images/benefit/llm@2x.png 2x, ./images/benefit/llm@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">05</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Большие языковые модели (LLM)</h3>
                                            <div class="benefit-plate__text">
                                                <p>Применение LLM для прикладных задач: автоматизация, создание
                                                    цифрового ассистента. Исследование и&nbsp;применение специальных
                                                    алгоритмов и&nbsp;техник, например, RAG, графы знаний. Безопасность
                                                    LLM.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/dev-sec-ops-xl.webp, ./images/benefit/dev-sec-ops-xl@2x.webp 2x, ./images/benefit/dev-sec-ops-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/dev-sec-ops-d.webp, ./images/benefit/dev-sec-ops-d@2x.webp 2x, ./images/benefit/dev-sec-ops-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/dev-sec-ops.webp, ./images/benefit/dev-sec-ops@2x.webp 2x, ./images/benefit/dev-sec-ops@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/dev-sec-ops.png"
                                                         srcset="./images/benefit/dev-sec-ops@2x.png 2x, ./images/benefit/dev-sec-ops@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">06</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">Алгоритмы и&nbsp;методы
                                                DevSecOps</h3>
                                            <div class="benefit-plate__text">
                                                <p>Это направление исследований фокусируется на&nbsp;разработке и&nbsp;совершенствовании
                                                    алгоритмов, которые автоматизируют процессы DevSecOps, в&nbsp;том
                                                    числе с&nbsp;применением LLM.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="advantages-solutions__item">
                                    <div class="benefit-plate">
                                        <div class="benefit-plate__image-wrap">
                                            <div class="benefit-plate__bg-decor-wrap">
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--top">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                                <div class="benefit-plate__bg-decor benefit-plate__bg-decor--bottom">
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                    <svg width="1em" height="1em" viewBox="0 0 15 15"
                                                         data-icon="icon-plus">

                                                        <use xlink:href="#ai:local:icon-plus"></use>

                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="benefit-plate__image">


                                                <picture>

                                                    <source media="(min-width: 1921px)"
                                                            srcset="./images/benefit/benefit-code-xl.webp, ./images/benefit/benefit-code-xl@2x.webp 2x, ./images/benefit/benefit-code-xl@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(min-width: 768px)"
                                                            srcset="./images/benefit/benefit-code-d.webp, ./images/benefit/benefit-code-d@2x.webp 2x, ./images/benefit/benefit-code-d@3x.webp 3x"
                                                            type="image/webp">
                                                    <source media="(max-width: 767px)"
                                                            srcset="./images/benefit/benefit-code.webp, ./images/benefit/benefit-code@2x.webp 2x, ./images/benefit/benefit-code@3x.webp 3x"
                                                            type="image/webp">
                                                    <img src="./images/benefit/benefit-code.png"
                                                         srcset="./images/benefit/benefit-code@2x.png 2x, ./images/benefit/benefit-code@3x.png 3x"
                                                         alt="Картинка" width="473" height="473" loading="lazy">
                                                </picture>

                                            </div>
                                        </div>
                                        <div class="benefit-plate__content-wrap">
                                            <div class="benefit-plate__counter-wrap">
                                                <span class="benefit-plate__counter">07</span>
                                            </div>
                                            <h3 class="title benefit-plate__title">DevOps/MLOps</h3>
                                            <div class="benefit-plate__text">
                                                <p>Исследование и&nbsp;применение различных фреймворков, настройка
                                                    оборудования, создание инфраструктуры, автоматизация
                                                    исследовательских задач.</p>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </section>
    <section class="page-section" id="cooperations">

        <div class="cooperation">
            <div class="container">

                <div class="cooperation__inner">
                    <div class="cooperation__top">
                        <div class="section-title cooperation__title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">сотрудничество</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 4; --line-total: 2;"><span class="word" data-word="мы"
                                                                                    style="--word-index: 0; --line-index: 0;"><span
                                                class="word-inner">мы</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="сотрудничаем"
                                                                             style="--word-index: 1; --line-index: 0;"><span
                                                class="word-inner">сотрудничаем</span></span><br> <span class="word"
                                                                                                        data-word="с"
                                                                                                        style="--word-index: 2; --line-index: 1;"><span
                                                class="word-inner">с</span></span><span class="whitespace"> </span><span
                                            class="word" data-word="вузами"
                                            style="--word-index: 3; --line-index: 1;"><span
                                                class="word-inner">вузами</span></span></h2>
                            </div>

                        </div>
                        <p class="cooperation__top-description">
                            Исследовательский центр UDV Group сотрудничает с&nbsp;вузами в&nbsp;образовательных
                            проектах: лекции
                            и&nbsp;семинары, проектные практикумы, дипломы, конференции и&nbsp;совместные статьи
                        </p>
                    </div>
                    <div class="cooperation__list-container">
                        <div class="cooperation__list-wrap swiper swiper-backface-hidden swiper-initialized swiper-horizontal swiper-free-mode"
                             data-cooperations-slider="container">
                            <ul class="cooperation__list swiper-wrapper" data-cooperations-slider="wrapper">
                                <li class="cooperation__item swiper-slide swiper-slide-active"
                                    data-cooperations-slider="slide" style="margin-right: 8px;">
                                    <img src="./images/svg/ufu.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                                <li class="cooperation__item swiper-slide swiper-slide-next"
                                    data-cooperations-slider="slide" style="margin-right: 8px;">
                                    <img src="./images/svg/hse.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                                <li class="cooperation__item swiper-slide" data-cooperations-slider="slide"
                                    style="margin-right: 8px;">
                                    <img src="./images/svg/ufu-2.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                                <li class="cooperation__item swiper-slide" data-cooperations-slider="slide"
                                    style="margin-right: 8px;">
                                    <img src="./images/svg/itmo.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                                <li class="cooperation__item swiper-slide" data-cooperations-slider="slide"
                                    style="margin-right: 8px;">
                                    <img src="./images/svg/ufu-3.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                                <li class="cooperation__item swiper-slide" data-cooperations-slider="slide"
                                    style="margin-right: 8px;">
                                    <img src="./images/svg/mfti.svg" alt="Логотип партнера" width="253" height="168"
                                         loading="lazy">


                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </section>
    <section class="page-section" id="team">

        <div class="team-research">
            <div class="container">

                <div class="team-research__inner">
                    <div class="team-research__top">
                        <div class="section-title team-research__title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">команда</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 3; --line-total: 2;"><span class="word" data-word="команда"
                                                                                    style="--word-index: 0; --line-index: 0;"><span
                                                class="word-inner">команда</span></span><br><span class="word"
                                                                                                  data-word="исследовательского"
                                                                                                  style="--word-index: 1; --line-index: 1;"><span
                                                class="word-inner">исследовательского</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="центра"
                                                                             style="--word-index: 2; --line-index: 1;"><span
                                                class="word-inner">центра</span></span></h2>
                            </div>

                        </div>

                        <ul class="team-research__tags-list">
                            <li class="team-research__item">
                                <div class="tag-text tag-text--team-research tag-text--bordered tag-text--card">
                                    <p class="tag-text__text">UЧИ</p>
                                </div>
                            </li>
                            <li class="team-research__item">
                                <div class="tag-text tag-text--team-research tag-text--bordered tag-text--card">
                                    <p class="tag-text__text">Dействуй</p>
                                </div>
                            </li>
                            <li class="team-research__item">
                                <div class="tag-text tag-text--team-research tag-text--bordered tag-text--card">
                                    <p class="tag-text__text">Vдохновляй</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="team-research__main">
                        <div class="team-research__image-list-wrap swiper swiper-initialized swiper-horizontal swiper-backface-hidden"
                             data-team-research-slider="container">
                            <ul class="team-research__image-list swiper-wrapper" data-team-research-slider="wrapper"
                                style="transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;">
                                <li class="team-research__image-item swiper-slide swiper-slide-active"
                                    data-team-research-slider="slide" style="margin-right: 8px;">


                                    <picture>

                                        <source media="(min-width: 1921px)"
                                                srcset="./images/research-center-team/research-center-team-1-xl.webp, ./images/research-center-team/research-center-team-1-xl@2x.webp 2x, ./images/research-center-team/research-center-team-1-xl@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(min-width: 768px)"
                                                srcset="./images/research-center-team/research-center-team-1-d.webp, ./images/research-center-team/research-center-team-1-d@2x.webp 2x, ./images/research-center-team/research-center-team-1-d@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(max-width: 767px)"
                                                srcset="./images/research-center-team/research-center-team-1.webp, ./images/research-center-team/research-center-team-1@2x.webp 2x, ./images/research-center-team/research-center-team-1@3x.webp 3x"
                                                type="image/webp">
                                        <img src="./images/research-center-team/research-center-team-1.png"
                                             srcset="./images/research-center-team/research-center-team-1@2x.png 2x, ./images/research-center-team/research-center-team-1@3x.png 3x"
                                             alt="Картинка" width="554" height="626" loading="lazy">
                                    </picture>

                                </li>
                                <li class="team-research__image-item swiper-slide team-research__image-item--wide swiper-slide-next"
                                    data-team-research-slider="slide" style="margin-right: 8px;">


                                    <picture>

                                        <source media="(min-width: 1921px)"
                                                srcset="./images/research-center-team/research-center-team-2-xl.webp, ./images/research-center-team/research-center-team-2-xl@2x.webp 2x, ./images/research-center-team/research-center-team-2-xl@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(min-width: 768px)"
                                                srcset="./images/research-center-team/research-center-team-2-d.webp, ./images/research-center-team/research-center-team-2-d@2x.webp 2x, ./images/research-center-team/research-center-team-2-d@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(max-width: 767px)"
                                                srcset="./images/research-center-team/research-center-team-2.webp, ./images/research-center-team/research-center-team-2@2x.webp 2x, ./images/research-center-team/research-center-team-2@3x.webp 3x"
                                                type="image/webp">
                                        <img src="./images/research-center-team/research-center-team-2.png"
                                             srcset="./images/research-center-team/research-center-team-2@2x.png 2x, ./images/research-center-team/research-center-team-2@3x.png 3x"
                                             alt="Картинка" width="1146" height="626" loading="lazy">
                                    </picture>

                                </li>
                                <li class="team-research__image-item swiper-slide" data-team-research-slider="slide"
                                    style="margin-right: 8px;">


                                    <picture>

                                        <source media="(min-width: 1921px)"
                                                srcset="./images/research-center-team/research-center-team-3-xl.webp, ./images/research-center-team/research-center-team-3-xl@2x.webp 2x, ./images/research-center-team/research-center-team-3-xl@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(min-width: 768px)"
                                                srcset="./images/research-center-team/research-center-team-3-d.webp, ./images/research-center-team/research-center-team-3-d@2x.webp 2x, ./images/research-center-team/research-center-team-3-d@3x.webp 3x"
                                                type="image/webp">
                                        <source media="(max-width: 767px)"
                                                srcset="./images/research-center-team/research-center-team-3.webp, ./images/research-center-team/research-center-team-3@2x.webp 2x, ./images/research-center-team/research-center-team-3@3x.webp 3x"
                                                type="image/webp">
                                        <img src="./images/research-center-team/research-center-team-3.png"
                                             srcset="./images/research-center-team/research-center-team-3@2x.png 2x, ./images/research-center-team/research-center-team-3@3x.png 3x"
                                             alt="Картинка" width="554" height="626" loading="lazy">
                                    </picture>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </section>
    <section class="page-section" id="links">

        <div class="links">
            <div class="container">

                <div class="links__inner">
                    <div class="links__aside">
                        <div class="section-title links__title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">ссылки</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 5; --line-total: 2;"><span class="word" data-word="узнайте"
                                                                                    style="--word-index: 0; --line-index: 0;"><span
                                                class="word-inner">узнайте</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="больше"
                                                                             style="--word-index: 1; --line-index: 0;"><span
                                                class="word-inner">больше</span></span><br> <span class="word"
                                                                                                  data-word="о"
                                                                                                  style="--word-index: 2; --line-index: 1;"><span
                                                class="word-inner">о</span></span><span class="whitespace"> </span><span
                                            class="word" data-word="наших"
                                            style="--word-index: 3; --line-index: 1;"><span
                                                class="word-inner">наших</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="наработках"
                                                                             style="--word-index: 4; --line-index: 1;"><span
                                                class="word-inner">наработках</span></span></h2>
                            </div>

                        </div>
                        <p class="links__title-description">
                            Исследовательский центр делится результатами своих наработок в&nbsp;рамках компании
                            CyberLympha, входящей
                            в&nbsp;группу компаний UDV Group
                        </p>
                        <div class="links__logo">
                            <img src="./images/svg/logo-cyber-lympha.svg" alt="Картинка" width="262" height="52"
                                 loading="lazy">


                        </div>
                    </div>
                    <ul class="links__list">
                        <li class="links__item">
                            <div class="link-card">
                                <div class="link-card__bg">
                                    <div class="link-card__bg-image">


                                        <picture>

                                            <source media="(min-width: 1921px)"
                                                    srcset="./images/bg/bg-links-green-xl.webp, ./images/bg/bg-links-green-xl@2x.webp 2x, ./images/bg/bg-links-green-xl@3x.webp 3x"
                                                    type="image/webp">
                                            <source media="(min-width: 768px)"
                                                    srcset="./images/bg/bg-links-green-d.webp, ./images/bg/bg-links-green-d@2x.webp 2x, ./images/bg/bg-links-green-d@3x.webp 3x"
                                                    type="image/webp">
                                            <source media="(max-width: 767px)"
                                                    srcset="./images/bg/bg-links-green.webp, ./images/bg/bg-links-green@2x.webp 2x, ./images/bg/bg-links-green@3x.webp 3x"
                                                    type="image/webp">
                                            <img src="./images/bg/bg-links-green.png"
                                                 srcset="./images/bg/bg-links-green@2x.png 2x, ./images/bg/bg-links-green@3x.png 3x"
                                                 alt="Картинка" width="577" height="553" loading="lazy">
                                        </picture>

                                    </div>
                                    <div class="link-card__bg-pixels" data-pixels="link-card" data-pixels-qty="45">
                                        <div class="pixel" style="opacity: 0; --delay: 0.07475859819273856;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7669522243143903;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.09797606541727122;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.380250422332149;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5083824370113288;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.35541161978081237;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.12838611581993042;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.584025613794714;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5024911416626496;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.007384667526005417;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.09630949511354325;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.6381890448467173;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.8415798455070935;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.10568397451377565;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.7300447777880437;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.3912802663408952;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.059306242445200885;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.9998949267854336;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.0828772661637136;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.952348363125592;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.30086060426978567;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.985984594854092;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.11468215855683184;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.6109424221003488;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.21340211835321865;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.0884542150370713;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.22333277443462496;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.801516519263723;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.0743843201032206;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.19234644576321203;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.8776927900165425;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.5053941388251673;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.4531079615392868;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.011720173815875423;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.20513573497927373;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.43070022471070546;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5229216660946248;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.6738350722524615;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.4497237626915833;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7824818007388348;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7634676061632311;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.6344865156853967;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.8811470868781868;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.6451209666446001;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5656213557682794;"></div>
                                    </div>
                                </div>
                                <div class="link-card__inner">
                                    <div class="link-card__image">
                                        <img src="./images/svg/logo-habr.svg" alt="Логотип" width="48" height="48"
                                             loading="lazy">


                                    </div>
                                    <h3 class="link-card__title">Хабр</h3>
                                    <p class="link-card__text">На&nbsp;Хабре мы&nbsp;публикуем полезные образовательные
                                        и&nbsp;обзорные статьи о&nbsp;кибербезопасности</p>
                                    <a href="#"
                                       class="button button--size-xl-m button--transparent link-card__btn"><span
                                                class="button__text">перейти на сайт</span><span class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></a>
                                </div>
                            </div>
                        </li>
                        <li class="links__item">
                            <div class="link-card">
                                <div class="link-card__bg">
                                    <div class="link-card__bg-image">


                                        <picture>

                                            <source media="(min-width: 1921px)"
                                                    srcset="./images/bg/bg-links-violet-xl.webp, ./images/bg/bg-links-violet-xl@2x.webp 2x, ./images/bg/bg-links-violet-xl@3x.webp 3x"
                                                    type="image/webp">
                                            <source media="(min-width: 768px)"
                                                    srcset="./images/bg/bg-links-violet-d.webp, ./images/bg/bg-links-violet-d@2x.webp 2x, ./images/bg/bg-links-violet-d@3x.webp 3x"
                                                    type="image/webp">
                                            <source media="(max-width: 767px)"
                                                    srcset="./images/bg/bg-links-violet.webp, ./images/bg/bg-links-violet@2x.webp 2x, ./images/bg/bg-links-violet@3x.webp 3x"
                                                    type="image/webp">
                                            <img src="./images/bg/bg-links-violet.png"
                                                 srcset="./images/bg/bg-links-violet@2x.png 2x, ./images/bg/bg-links-violet@3x.png 3x"
                                                 alt="Картинка" width="577" height="553" loading="lazy">
                                        </picture>

                                    </div>
                                    <div class="link-card__bg-pixels" data-pixels="link-card" data-pixels-qty="45">
                                        <div class="pixel" style="opacity: 0; --delay: 0.7464287928301419;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.3332802627859872;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7865699693083781;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.7935111928650127;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7508908222758519;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.7261498807877014;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.9889169358484733;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.12390677419378804;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.882115365595062;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.7429946960739018;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.12663382270974655;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.3653998094767761;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5734769027596531;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.5300481659158811;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.6139404216471913;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.971921430125499;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.9123017249663476;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.3896617230559132;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.6891286643926597;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.6270351946285155;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.3740976225436179;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.8629269765970913;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.32861814976062087;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.9551505429197062;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.5836396726297011;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.20377343116615343;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.9131967166977419;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.14754688374696512;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.93626953832763;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.288958968397649;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.5044740622162052;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.10949538129266512;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.43908619008545213;"></div>
                                        <div class="pixel" style="opacity: 0.75; --delay: 0.6035138322618514;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.4599258451013677;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.3853270473899655;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.28086070017717946;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.5443769312094866;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.48491438506069695;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.2645645983391982;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.3684274413545059;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.41183238687169155;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.8950158144057243;"></div>
                                        <div class="pixel" style="opacity: 0.35; --delay: 0.25456056620304546;"></div>
                                        <div class="pixel" style="opacity: 0; --delay: 0.28806101416409935;"></div>
                                    </div>
                                </div>
                                <div class="link-card__inner">
                                    <div class="link-card__image">
                                        <img src="./images/svg/logo-github.svg" alt="Логотип" width="48" height="48"
                                             loading="lazy">


                                    </div>
                                    <h3 class="link-card__title">GItHub</h3>
                                    <p class="link-card__text">На&nbsp;GitHub мы&nbsp;выкладываем<br> бесплатные лекции,
                                        практические задания и&nbsp;другие материалы</p>
                                    <a href="#"
                                       class="button button--size-xl-m button--transparent link-card__btn"><span
                                                class="button__text">перейти на сайт</span><span class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></a>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>

            </div>
        </div>

    </section>
    <section class="page-section" id="events">

        <div class="other-news other-news--press-release">
            <div class="container">

                <div class="other-news__inner">

                    <div class="other-news__top">
                        <div class="section-title other-news__section-title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">события</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 3; --line-total: 2;"><span class="word"
                                                                                    data-word="пресс-релизы"
                                                                                    style="--word-index: 0; --line-index: 0;"><span
                                                class="word-inner">пресс-релизы</span></span><br> <span class="word"
                                                                                                        data-word="исследовательского"
                                                                                                        style="--word-index: 1; --line-index: 1;"><span
                                                class="word-inner">исследовательского</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="центра"
                                                                             style="--word-index: 2; --line-index: 1;"><span
                                                class="word-inner">центра</span></span></h2>
                            </div>

                        </div>

                    </div>
                    <div class="other-news__list-wrap swiper swiper-backface-hidden swiper-initialized swiper-horizontal"
                         data-other-news-slider="container">
                        <ul class="other-news__list swiper-wrapper" style="cursor: grab;">
                            <li class="other-news__item swiper-slide swiper-slide-active"
                                style="width: 297.913px; margin-right: 16px;">
                                <div class="article-card article-card--other-news">
                                    <a class="article-card__inner" href="#">

                                        <div class="article-card__image">


                                            <picture>
                                                <source media="(min-width: 768px)"
                                                        srcset="./images/press-release/press-release-1-xl.webp, ./images/press-release/press-release-1-xl@2x.webp 2x, ./images/press-release/press-release-1-xl@3x.webp 3x"
                                                        type="image/webp">

                                                <source media="(max-width: 767px)"
                                                        srcset="./images/press-release/press-release-1.webp, ./images/press-release/press-release-1@2x.webp 2x, ./images/press-release/press-release-1@3x.webp 3x"
                                                        type="image/webp">
                                                <img src="./images/press-release/press-release-1.png"
                                                     srcset="./images/press-release/press-release-1@2x.png 2x, ./images/press-release/press-release-1@3x.png 3x"
                                                     alt="Картинка" width="1573" height="836" loading="lazy">
                                            </picture>

                                        </div>
                                        <h2 class="title article-card__title">Hack Secure 2024</h2>
                                        <div class="article-card__text">
                                            <p>Мероприятие, на&nbsp;котором эксперты по&nbsp;кибербезопасности обсуждают
                                                современные вызовы и&nbsp;эффективные решения для противодействия
                                                угрозам в&nbsp;цифровом мире</p>
                                        </div>
                                        <div class="item-info item-info--small">
                                            <div class="item-info__wrap">
                                                <p class="item-info__category">исследовательский центр</p>
                                                <div class="item-info__date-wrap">
                                                    <time class="item-info__date" datetime="2024-07-19T00:00:00.000Z">
                                                        18.07.24
                                                    </time>

                                                    <span class="item-info__readtime">
            <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-clock">

  <symbol id="ai:local:icon-clock"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                         stroke-linejoin="round" stroke-width="1.2"
                                         d="M10 5.833V10l2.5 2.5M2.5 10a7.5 7.5 0 1 0 15 0 7.5 7.5 0 0 0-15 0Z"></path></symbol><use
                        xlink:href="#ai:local:icon-clock"></use>

</svg>
            5 минут
          </span>
                                                </div>
                                            </div>

                                        </div>
                                    </a>
                                </div>
                            </li>
                            <li class="other-news__item swiper-slide swiper-slide-next"
                                style="width: 297.913px; margin-right: 16px;">
                                <div class="article-card article-card--other-news">
                                    <a class="article-card__inner" href="#">

                                        <div class="article-card__image">


                                            <picture>
                                                <source media="(min-width: 768px)"
                                                        srcset="./images/press-release/press-release-2-xl.webp, ./images/press-release/press-release-2-xl@2x.webp 2x, ./images/press-release/press-release-2-xl@3x.webp 3x"
                                                        type="image/webp">

                                                <source media="(max-width: 767px)"
                                                        srcset="./images/press-release/press-release-2.webp, ./images/press-release/press-release-2@2x.webp 2x, ./images/press-release/press-release-2@3x.webp 3x"
                                                        type="image/webp">
                                                <img src="./images/press-release/press-release-2.png"
                                                     srcset="./images/press-release/press-release-2@2x.png 2x, ./images/press-release/press-release-2@3x.png 3x"
                                                     alt="Картинка" width="1573" height="836" loading="lazy">
                                            </picture>

                                        </div>
                                        <h2 class="title article-card__title">Выиграли конкурс Cyber Front</h2>
                                        <div class="article-card__text">
                                            <p>Масштабное мероприятие, в&nbsp;котором участвовали талантливые команды и&nbsp;индивидуальные
                                                участники из&nbsp;разных областей</p>
                                        </div>
                                        <div class="item-info item-info--small">
                                            <div class="item-info__wrap">
                                                <p class="item-info__category">исследовательский центр</p>
                                                <div class="item-info__date-wrap">
                                                    <time class="item-info__date" datetime="2024-07-19T00:00:00.000Z">
                                                        18.07.24
                                                    </time>

                                                    <span class="item-info__readtime">
            <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-clock">

  <use xlink:href="#ai:local:icon-clock"></use>

</svg>
            5 минут
          </span>
                                                </div>
                                            </div>

                                        </div>
                                    </a>
                                </div>
                            </li>
                            <li class="other-news__item swiper-slide" style="width: 297.913px; margin-right: 16px;">
                                <div class="article-card article-card--other-news">
                                    <a class="article-card__inner" href="#">

                                        <div class="article-card__image">


                                            <picture>
                                                <source media="(min-width: 768px)"
                                                        srcset="./images/press-release/press-release-3-xl.webp, ./images/press-release/press-release-3-xl@2x.webp 2x, ./images/press-release/press-release-3-xl@3x.webp 3x"
                                                        type="image/webp">

                                                <source media="(max-width: 767px)"
                                                        srcset="./images/press-release/press-release-3.webp, ./images/press-release/press-release-3@2x.webp 2x, ./images/press-release/press-release-3@3x.webp 3x"
                                                        type="image/webp">
                                                <img src="./images/press-release/press-release-3.png"
                                                     srcset="./images/press-release/press-release-3@2x.png 2x, ./images/press-release/press-release-3@3x.png 3x"
                                                     alt="Картинка" width="1573" height="836" loading="lazy">
                                            </picture>

                                        </div>
                                        <h2 class="title article-card__title">Digital Fortress 2024</h2>
                                        <div class="article-card__text">
                                            <p>Конференция, ориентированная на&nbsp;обсуждение стратегий и&nbsp;передовых
                                                технологий, которые помогают укрепить цифровые фортификации и&nbsp;защитить
                                                корпоративные данные.</p>
                                        </div>
                                        <div class="item-info item-info--small">
                                            <div class="item-info__wrap">
                                                <p class="item-info__category">исследовательский центр</p>
                                                <div class="item-info__date-wrap">
                                                    <time class="item-info__date" datetime="2024-07-19T00:00:00.000Z">
                                                        18.07.24
                                                    </time>

                                                    <span class="item-info__readtime">
            <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-clock">

  <use xlink:href="#ai:local:icon-clock"></use>

</svg>
            5 минут
          </span>
                                                </div>
                                            </div>

                                        </div>
                                    </a>
                                </div>
                            </li>
                        </ul>
                        <a href="#" data-da-max=".other-news__list-wrap, 767, last"
                           class="button button--size-xl-m button--solid-white other-news__button dynamic-adaptive"><span
                                    class="button__text">все пресс-релизы</span></a></div>
                </div>

            </div>
        </div>

    </section>
    <section class="page-section page-section--p-b" id="demo">

        <div class="write-to-us-form">
            <div class="container write-to-us-form__container">

                <div class="write-to-us-form__inner">
                    <div class="write-to-us-form__aside">
                        <div class="write-to-us-form__bg">
                            <div class="write-to-us-form__bg-gradient">


                                <picture>

                                    <source media="(min-width: 1921px)"
                                            srcset="./images/bg/bg-write-to-us-form-xl.webp, ./images/bg/bg-write-to-us-form-xl@2x.webp 2x, ./images/bg/bg-write-to-us-form-xl@3x.webp 3x"
                                            type="image/webp">
                                    <source media="(min-width: 768px)"
                                            srcset="./images/bg/bg-write-to-us-form-d.webp, ./images/bg/bg-write-to-us-form-d@2x.webp 2x, ./images/bg/bg-write-to-us-form-d@3x.webp 3x"
                                            type="image/webp">
                                    <source media="(max-width: 767px)"
                                            srcset="./images/bg/bg-write-to-us-form.webp, ./images/bg/bg-write-to-us-form@2x.webp 2x, ./images/bg/bg-write-to-us-form@3x.webp 3x"
                                            type="image/webp">
                                    <img src="./images/bg/bg-write-to-us-form.png"
                                         srcset="./images/bg/bg-write-to-us-form@2x.png 2x, ./images/bg/bg-write-to-us-form@3x.png 3x"
                                         alt="Изображение." width="1100" height="606" loading="lazy">
                                </picture>

                            </div>
                            <div class="write-to-us-form__bg-pixels" data-pixels="write-to-us-form"
                                 data-pixels-qty="35">

                            </div>
                        </div>
                        <div class="section-title write-to-us-form__title">
                            <div class="section-title__wrap">
                                <p class="section-title__badge">оставьте заявку</p>
                                <h2 data-animate="title"
                                    class="title title--h2 section-title__title words lines splitting is-show"
                                    style="--word-total: 7; --line-total: 2;"><span class="word" data-word="напишите"
                                                                                    style="--word-index: 0; --line-index: 0;"><span
                                                class="word-inner">напишите</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="нам,"
                                                                             style="--word-index: 1; --line-index: 0;"><span
                                                class="word-inner">нам,</span></span><br> <span class="word"
                                                                                                data-word="если"
                                                                                                style="--word-index: 2; --line-index: 1;"><span
                                                class="word-inner">если</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="у"
                                                                             style="--word-index: 3; --line-index: 1;"><span
                                                class="word-inner">у</span></span><span class="whitespace"> </span><span
                                            class="word" data-word="вас" style="--word-index: 4; --line-index: 1;"><span
                                                class="word-inner">вас</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="есть"
                                                                             style="--word-index: 5; --line-index: 1;"><span
                                                class="word-inner">есть</span></span><span
                                            class="whitespace"> </span><span class="word" data-word="вопросы"
                                                                             style="--word-index: 6; --line-index: 1;"><span
                                                class="word-inner">вопросы</span></span></h2>
                            </div>

                        </div>
                        <p class="write-to-us-form__description">Ответим в&nbsp;рабочие дни с&nbsp;9:00 до&nbsp;18:00 по&nbsp;Москве</p>
                    </div>
                    <div class="write-to-us-form__form" data-form-validate="" data-callback="request"
                         data-button-disabled="">
                        <form action="#" novalidate="">
                            <div class="write-to-us-form__fields">
                                <div class="custom-input write-to-us-form__field write-to-us-form__field--wide"
                                     data-validate-type="text" data-required="" data-message-base="Введите имя"
                                     data-message-extra="Введите корректное имя" data-message-succes=""
                                     data-input-focus="">
                                    <label>
                                        <input type="text" name="name" minlength="2" maxlength="20">
                                        <span class="custom-input__label">Ваше имя</span>
                                    </label>


                                </div>
                                <div class="custom-input" data-validate-type="email" data-required=""
                                     data-message-base="Введите e-mail" data-message-extra="Не корректный e-mail"
                                     data-message-succes="" data-input-focus="">
                                    <label>
                                        <input type="email" name="email" maxlength="256">
                                        <span class="custom-input__label">Электронная почта</span>
                                    </label>


                                </div>
                                <div class="custom-input" data-validate-type="phone" data-required=""
                                     data-message-base="Введите номер телефона" data-message-extra="Не корректный номер"
                                     data-message-succes="" data-input-focus="" data-phone-length="18">
                                    <label>
                                        <input type="tel" name="email" maxlength="256">
                                        <span class="custom-input__label">Номер телефона</span>
                                    </label>


                                </div>
                                <div class="custom-input write-to-us-form__field write-to-us-form__field--wide"
                                     data-input-focus="">
                                    <label>
                                        <input type="text" name="comment">
                                        <span class="custom-input__label">Комментарий</span>
                                    </label>


                                </div>
                            </div>
                            <div class="custom-toggle write-to-us-form__toggle"
                                 data-message-base="Согласитесь с политикой конфиденциальности"
                                 data-validate-type="checkbox">
                                <label>
                                    <input type="checkbox" required="">

                                    <span class="custom-toggle__icon">
          <svg width="1em" height="1em" viewBox="0 0 12 12" data-icon="icon-check">

  <symbol id="ai:local:icon-check"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                         stroke-linejoin="round" stroke-width="1.5"
                                         d="M2.5 6 5 8.5l5-5"></path></symbol><use
                      xlink:href="#ai:local:icon-check"></use>

</svg>
        </span>

                                    <span class="custom-toggle__label">

            <span class="custom-toggle__label-text">Я согласен с <a href="#">Политикой конфиденциальности</a></span>
            <span class="custom-toggle__label-icon">
              <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
            </span>

        </span>
                                </label>
                            </div>
                            <button type="submit"
                                    class="button button--solid-green button--size-m write-to-us-form__send-btn is-disabled">
                                <span class="button__text">отправить запрос</span><span class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></button>
                        </form>
                    </div>
                </div>

            </div>
        </div>

    </section>
