<?php

if (!defined("B_PROLOG_INCLUDED") || B_PROLOG_INCLUDED !== true) die();

/**
 * @global CMain $APPLICATION
 * @var Asset $assets
 */

use Bitrix\Main\Page\Asset;

global $USER;
$assets = Asset::getInstance();
?>
<!doctype html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="description" content="Astro description">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width">
    <link rel="icon" type="image/svg+xml" href="/favicon.svg">
    <meta name="generator" content="Astro v4.13.1">
    <!-- TEMP CODE -->

    <!-- TEMP CODE -->

    <title><? $APPLICATION->ShowTitle() ?></title>
    <? $assets->addCss(SITE_TEMPLATE_PATH . '/css/style.css'); ?>
    <? $assets->addCss(SITE_TEMPLATE_PATH . '/css/custom.css'); ?>
    <? $assets->addJs(SITE_TEMPLATE_PATH . '/js/scripts.js'); ?>
    <? $APPLICATION->ShowHead(); ?>

    <script type="module" src="/local/templates/newudv/js/scripts.js"></script>
</head>

<body>
<div id="panel" style="position: fixed;z-index: 10000;top: 0%=;width: 100%;">
    <? $APPLICATION->ShowPanel(); ?>
</div>
<header class="header is-transparent" data-header="sticky">
    <div class="container">
        <div class="header__inner">
            <div class="header__top">
                <div class="header__logo-wrap">
                     <span class="logo header__logo">
                        <span class="logo__image">
                             <svg width="5.04em" height="1em" viewBox="0 0 151 30" data-icon="logo-udv">
                      <symbol id="ai:local:logo-udv"><g fill="none"><path fill="#00D29D" fill-rule="evenodd"
                                                                          d="M.92 12.743 12.596.931a3.138 3.138 0 0 1 4.46 0L28.73 12.743a3.227 3.227 0 0 1 0 4.514L17.054 29.069a3.137 3.137 0 0 1-4.461 0L.92 17.257a3.228 3.228 0 0 1 0-4.514Zm1.164 1.165 11.663-11.8c.593-.6 1.564-.6 2.158 0l11.662 11.8c.593.6.593 1.584 0 2.184l-11.663 11.8c-.593.6-1.564.6-2.158 0l-11.662-11.8a1.562 1.562 0 0 1 0-2.184Z"
                                                                          clip-rule="evenodd"/><path fill="#00D29D"
                                                                                                     d="M44.271 9.183c0-.134.022-.254.063-.36a.698.698 0 0 1 .194-.275.84.84 0 0 1 .278-.163.973.973 0 0 1 .642 0 .878.878 0 0 1 .271.163c.171.15.257.355.257.615v6.541a6.7 6.7 0 0 1-.21 1.718 5.18 5.18 0 0 1-.63 1.46c-.279.441-.6.827-.965 1.16a5.294 5.294 0 0 1-1.221.83 6.382 6.382 0 0 1-2.855.666 6.343 6.343 0 0 1-2.855-.665c-.45-.223-.857-.5-1.221-.83a5.62 5.62 0 0 1-.965-1.16 5.162 5.162 0 0 1-.63-1.46 6.727 6.727 0 0 1-.21-1.718v-6.6c0-.122.022-.232.064-.329a.644.644 0 0 1 .198-.251.869.869 0 0 1 .27-.146 1.011 1.011 0 0 1 .636.002.849.849 0 0 1 .278.155.683.683 0 0 1 .195.257.82.82 0 0 1 .064.33v6.582c0 .444.049.856.147 1.234.098.376.244.721.44 1.033.196.313.422.588.68.825.257.236.545.434.863.593a4.526 4.526 0 0 0 2.046.481c.724 0 1.406-.16 2.046-.481.319-.16.607-.358.864-.594.258-.236.484-.512.68-.824.195-.313.341-.657.44-1.033.097-.379.146-.79.146-1.235V9.182Zm9.941-.694c.851 0 1.636.173 2.355.52.72.348 1.26.845 1.619 1.49v-4.94c0-.264.09-.475.27-.632a.936.936 0 0 1 .638-.236c.245 0 .454.078.625.236.172.157.258.367.258.632v14.843c0 .265-.082.476-.245.633-.164.157-.385.236-.663.236-.556 0-.834-.29-.834-.869v-1.018a3.65 3.65 0 0 1-1.692 1.614 5.388 5.388 0 0 1-2.33.521c-1.161 0-2.217-.26-3.166-.781-.948-.522-1.704-1.28-2.268-2.272-.564-.993-.847-2.184-.847-3.574 0-.943.209-1.907.626-2.892.417-.985 1.095-1.816 2.036-2.494.94-.679 2.146-1.018 3.618-1.018Zm.147 11.318c1.096-.066 2.008-.438 2.735-1.117.728-.679 1.091-1.58 1.091-2.706v-1.96c0-1.076-.367-1.97-1.104-2.681-.735-.712-1.667-1.092-2.796-1.142-1.128 0-2.031.252-2.71.757-.68.505-1.157 1.113-1.435 1.825-.279.71-.418 1.39-.418 2.035 0 1.19.245 2.159.736 2.903.49.745 1.091 1.279 1.803 1.601.711.323 1.41.484 2.097.484v.001Zm7.347-10.198a.708.708 0 0 1-.05-.305.8.8 0 0 1 .301-.636c.2-.17.435-.255.704-.255.167 0 .322.043.465.128a.747.747 0 0 1 .314.382l4.801 9.69 4.851-9.716a.76.76 0 0 1 .315-.356.893.893 0 0 1 .465-.127c.235 0 .449.072.641.216a.68.68 0 0 1 .29.573.998.998 0 0 1-.076.33l-5.681 11.42a.974.974 0 0 1-.365.433.9.9 0 0 1-.49.153c-.318 0-.587-.186-.804-.56l-5.68-11.37h-.001Zm-46.958 8.185c.206.208.31.426.31.652a.862.862 0 0 1-.285.64.905.905 0 0 1-.645.275c-.224 0-.448-.096-.671-.288l-4.441-4.362c-.275-.226-.413-.47-.413-.731 0-.297.146-.575.439-.836l4.465-4.336c.207-.227.448-.34.723-.34.224 0 .422.083.594.248a.79.79 0 0 1 .258.588c0 .208-.103.435-.31.679l-4.156 3.97 4.13 3.84h.001Z"/><path
                                      fill="#00D29D"
                                      d="M14.903 19.964c-.207.209-.31.426-.31.652a.86.86 0 0 0 .284.64c.19.183.404.274.645.274.224 0 .447-.095.672-.288l4.44-4.36c.275-.228.413-.471.413-.732 0-.296-.146-.575-.44-.836l-4.465-4.336c-.207-.227-.448-.34-.723-.34a.831.831 0 0 0-.593.248.786.786 0 0 0-.259.587c0 .21.104.436.31.68l4.157 3.97-4.13 3.84h-.001Z"/><path
                                      fill="currentColor"
                                      d="M95.47 20.388c0 1.15-.263 2.131-.788 2.945a4.907 4.907 0 0 1-2.156 1.835c-.912.41-1.934.616-3.068.616-.985 0-1.852-.123-2.6-.37-.747-.246-1.441-.665-2.082-1.256-.114-.115-.172-.23-.172-.345 0-.115.04-.206.124-.271a.46.46 0 0 1 .295-.098c.132 0 .238.032.32.098.707.542 1.36.912 1.96 1.109.6.197 1.318.295 2.156.295.936 0 1.794-.168 2.575-.505a4.25 4.25 0 0 0 1.872-1.54c.469-.69.703-1.527.703-2.513v-2.291a4.462 4.462 0 0 1-1.886 2.168c-.862.51-1.819.764-2.87.764a6.804 6.804 0 0 1-3.13-.74c-.969-.492-1.749-1.22-2.34-2.18-.592-.96-.887-2.107-.887-3.437 0-1.43.337-2.69 1.01-3.782.673-1.093 1.643-1.901 2.907-2.428a5.954 5.954 0 0 1 2.341-.468c1.068 0 2.086.288 3.055.863.871.575 1.47 1.305 1.8 2.193V8.61c0-.296.139-.443.418-.443.132 0 .238.041.32.123a.434.434 0 0 1 .124.32v11.778h-.001ZM92.045 9.423c-.821-.394-1.651-.583-2.489-.566-1.166.082-2.176.451-3.03 1.109-.74.575-1.286 1.265-1.64 2.07a6.37 6.37 0 0 0-.53 2.587c0 1.034.214 1.971.642 2.809a4.838 4.838 0 0 0 1.885 1.995c.829.493 1.819.74 2.969.74.903 0 1.716-.206 2.44-.617a4.56 4.56 0 0 0 1.7-1.65c.41-.69.615-1.446.615-2.268V13.49c0-.904-.222-1.71-.665-2.415-.444-.707-1.076-1.257-1.897-1.651Zm8.303 1.971c.263-.936.814-1.696 1.652-2.28a4.8 4.8 0 0 1 2.808-.874c.296 0 .444.14.444.42 0 .279-.148.418-.444.418-1.478 0-2.591.538-3.338 1.614-.748 1.076-1.122 2.427-1.122 4.053v5.569a.43.43 0 0 1-.123.32.402.402 0 0 1-.296.124.433.433 0 0 1-.32-.124.433.433 0 0 1-.123-.32V8.659c0-.115.041-.213.123-.295a.433.433 0 0 1 .32-.124c.116 0 .214.042.296.124a.4.4 0 0 1 .123.295v2.735Zm12.493 9.635a6.576 6.576 0 0 1-2.735-.567 6.178 6.178 0 0 1-2.168-1.626c-.986-1.216-1.479-2.653-1.479-4.313 0-.936.181-1.84.543-2.71a6.37 6.37 0 0 1 1.564-2.255 5.839 5.839 0 0 1 2.403-1.342 7.308 7.308 0 0 1 1.872-.222 8 8 0 0 1 1.849.222 5.744 5.744 0 0 1 3.153 2.168 7.03 7.03 0 0 1 1.38 3.672c.099 1.872-.394 3.466-1.478 4.78a6.19 6.19 0 0 1-2.169 1.626 6.573 6.573 0 0 1-2.735.567Zm1.577-11.975a6.393 6.393 0 0 0-3.154 0c-1.199.328-2.152 1.018-2.858 2.07a6.133 6.133 0 0 0-1.06 3.498c0 .673.107 1.327.321 1.96.213.631.534 1.203.961 1.712a5.122 5.122 0 0 0 1.872 1.404c.74.328 1.52.493 2.341.493.838 0 1.63-.164 2.378-.493a5.106 5.106 0 0 0 1.885-1.404 5.3 5.3 0 0 0 .961-1.7c.213-.625.32-1.274.32-1.947a6.15 6.15 0 0 0-1.072-3.511c-.715-1.06-1.68-1.754-2.895-2.082Zm8.846 6.578c0 .854.218 1.63.653 2.329a4.643 4.643 0 0 0 1.725 1.638 4.699 4.699 0 0 0 2.304.592c.854 0 1.708-.235 2.562-.703.854-.468 1.561-1.137 2.119-2.008.559-.87.838-1.88.838-3.03V8.684c0-.296.14-.444.419-.444.131 0 .238.042.32.124a.433.433 0 0 1 .123.32v11.68a.404.404 0 0 1-.123.295.435.435 0 0 1-.32.123c-.279 0-.419-.148-.419-.443v-3.45c-.246.904-.665 1.668-1.257 2.291a5.745 5.745 0 0 1-1.995 1.393c-.74.303-1.462.456-2.169.456-.969 0-1.885-.21-2.747-.63a5.123 5.123 0 0 1-2.094-1.86c-.534-.82-.801-1.79-.801-2.907V8.683c0-.296.14-.444.419-.444.132 0 .238.042.32.124a.43.43 0 0 1 .124.32v6.949h-.001Zm23.334 4.953c-.69.296-1.56.444-2.611.444-1.052 0-2.008-.255-2.871-.764a4.46 4.46 0 0 1-1.885-2.169v7.121c0 .296-.139.444-.419.444a.431.431 0 0 1-.32-.123.434.434 0 0 1-.124-.32V8.683c0-.131.042-.238.124-.32a.433.433 0 0 1 .32-.124c.28 0 .419.148.419.444v2.366c.328-.888.928-1.618 1.799-2.193.969-.575 1.987-.863 3.055-.863 1.101 0 2.131.275 3.092.826.961.55 1.729 1.334 2.304 2.353.575 1.018.862 2.193.862 3.524 0 1.314-.328 2.51-.985 3.585a5.472 5.472 0 0 1-2.76 2.304v-.001Zm-7.367-4.953c0 .838.206 1.594.616 2.267a4.531 4.531 0 0 0 1.701 1.614c.722.402 1.535.62 2.439.653 1.149.016 2.139-.222 2.969-.715a4.843 4.843 0 0 0 1.885-1.995c.427-.838.64-1.774.64-2.81 0-1.28-.287-2.357-.862-3.227-.575-.87-1.277-1.515-2.107-1.934-.829-.42-1.622-.629-2.378-.629-.854 0-1.655.181-2.402.543a4.459 4.459 0 0 0-1.811 1.589c-.46.698-.69 1.531-.69 2.5v2.144ZM78.526 4.728a.373.373 0 0 1 .375-.371c.206.002.37.17.37.377l-.745-.006Zm-.176 20.848.176-20.848.745.006-.177 20.85-.744-.008Zm.744.007a.373.373 0 0 1-.375.371.374.374 0 0 1-.369-.378l.744.007Z"/></g></symbol><use
                                    xlink:href="#ai:local:logo-udv"></use>

                    </svg>
  </span>
</span>
                </div>
                <button class="header__menu-btn" data-burger>
          <span class="header__menu-btn-icon header__menu-btn-icon--burger">
            <svg width="1em" height="1em" viewBox="0 0 32 32" data-icon="icon-burger">

  <symbol id="ai:local:icon-burger"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                          stroke-linejoin="round" stroke-width="1.5"
                                          d="M3.996 7.997h24.01M28.003 16H9.328m5.332 8.003H28"/></symbol><use
                        xlink:href="#ai:local:icon-burger"></use>

</svg>
          </span>
                    <span class="header__menu-btn-icon header__menu-btn-icon--cross">
            <svg width="1em" height="1em" viewBox="0 0 32 32" data-icon="icon-cross">

  <use xlink:href="#ai:local:icon-cross"></use>

</svg>
          </span>
                </button>
            </div>
            <nav class="header__nav main-nav" data-main-nav="main-nav">
                <div class="main-nav__bg-gradient">


                    <picture>
                        <source srcset="./images/bg/bg-mobile-menu.webp, ./images/bg/bg-mobile-menu@2x.webp 2x, ./images/bg/bg-mobile-menu@3x.webp 3x"
                                type="image/webp">
                        <img src="./images/bg/bg-mobile-menu.png"
                             srcset="./images/bg/bg-mobile-menu@2x.png 2x, ./images/bg/bg-mobile-menu@3x.png 3x"
                             alt="Картинка" width="298" height="431" loading="lazy">
                    </picture>
                </div>
                <div class="main-nav__bg-pixels">
                    <svg width="182" height="318" viewBox="0 0 182 318" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 351)" fill="white"
                              fill-opacity="0.3"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 351)" fill="white"
                              fill-opacity="0.2"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 312)" fill="white"
                              fill-opacity="0.2"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 156 195)" fill="white"
                              fill-opacity="0.75"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 273)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 117 273)" fill="white"
                              fill-opacity="0.2"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 273)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 39 234)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 234)" fill="white"
                              fill-opacity="0.3"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 195)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 156 312)" fill="white"
                              fill-opacity="0.3"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 195)" fill="white"
                              fill-opacity="0.6"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 156)" fill="white"
                              fill-opacity="0.4"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 39 156)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 117 117)" fill="white"
                              fill-opacity="0.3"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 117)" fill="white"
                              fill-opacity="0.2"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 78 78)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 39 78)" fill="white"
                              fill-opacity="0.2"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 0 78)" fill="white"
                              fill-opacity="0.25"></rect>
                        <rect width="39" height="39" transform="matrix(1 0 0 -1 39 39)" fill="white"
                              fill-opacity="0.75"></rect>
                    </svg>
                </div>
                <ul class="main-nav__list" data-scroll-lock-scrollable>
                    <li class="main-nav__item main-nav__item--submenu">
                <span class="main-nav__link main-nav__link--submenu">
                    решения
                    <span class="main-nav__link-icon">
                        <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="icon-chevron-down">

  <symbol id="ai:local:icon-chevron-down"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                                stroke-linejoin="round" stroke-width="1.5"
                                                d="m6.01 8.292 2.657 2.656 2.656-2.656"/></symbol><use
                                    xlink:href="#ai:local:icon-chevron-down"></use>

</svg>
                      </span>
                  </span>

                        <div class="main-nav__submenu" data-main-nav="submenu" data-scroll-lock-scrollable>
                            <div class="main-nav__submenu-wrap">
                                <div class="main-nav__submenu-header">
                                    <button type="button" class="main-nav__submenu-btn-back"
                                            data-main-nav="submenu-btn-back">
                          <span class="main-nav__submenu-btn-back-icon">
                            <svg width="1.34em" height="1em" viewBox="0 0 16 12" data-icon="icon-arrow-left">

  <symbol id="ai:local:icon-arrow-left"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                              stroke-linejoin="round" stroke-width="1.5"
                                              d="M1 6h14M6 1 1 6m5 5L1 6"/></symbol><use
                                        xlink:href="#ai:local:icon-arrow-left"></use>

</svg>
                          </span>
                                        <span class="main-nav__submenu-btn-back-text">решения</span>
                                    </button>
                                </div>
                                <div class="main-nav__submenu-list-wrap">
                                    <div class="main-nav__submenu-column">

                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      защита технологических сетей
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <symbol id="ai:local:icon-arrow-up-right"><path fill="none" stroke="currentColor" stroke-linecap="round"
                                                  stroke-linejoin="round" stroke-width="1.5"
                                                  d="m14.083 5.875-8.25 8.25m2.459-8.292 5.792.041.041 5.793"/></symbol><use
                                                    xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Решения помогают промышленным предприятиям эффективно защищать свои технологические сети от&nbsp;киберугроз</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      защита корпоративных сетей
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Мониторинг информационной безопасности и функционирования автоматизированных систем</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      защита технологических сетей
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Управление доступом на охраняемую территорию</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="main-nav__item main-nav__item--submenu">
                <span class="main-nav__link main-nav__link--submenu">
                    продукты
                    <span class="main-nav__link-icon">
                        <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="icon-chevron-down">

  <use xlink:href="#ai:local:icon-chevron-down"></use>

</svg>
                      </span>
                  </span>

                        <div class="main-nav__submenu" data-main-nav="submenu" data-scroll-lock-scrollable>
                            <div class="main-nav__submenu-wrap">
                                <div class="main-nav__submenu-header">
                                    <button type="button" class="main-nav__submenu-btn-back"
                                            data-main-nav="submenu-btn-back">
                          <span class="main-nav__submenu-btn-back-icon">
                            <svg width="1.34em" height="1em" viewBox="0 0 16 12" data-icon="icon-arrow-left">

  <use xlink:href="#ai:local:icon-arrow-left"></use>

</svg>
                          </span>
                                        <span class="main-nav__submenu-btn-back-text">продукты</span>
                                    </button>
                                </div>
                                <div class="main-nav__submenu-list-wrap">
                                    <div class="main-nav__submenu-column">
                                        <span class="main-nav__submenu-list-title">защита технологических сетей</span>
                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      ITM
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Система зонтичного мониторинга автоматизированных и&nbsp;информационных систем</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      UDV TAP Diode
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Комбинация диода данных и&nbsp;ответвителя трафика (TAP) с&nbsp;аппаратным байпасом</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      Industrial Firewall
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Межсетевой экран на&nbsp;базе архитектуры RISC&ndash;V&nbsp;с&nbsp;аппаратным ускорением обработки трафика</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      DATAPK Industrial Kit
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Комплекс решений для&nbsp;оперативного обнаружения инцидентов</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="main-nav__submenu-column">
                                        <span class="main-nav__submenu-list-title">защита корпоративных сетей</span>
                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      SGRC
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Автоматизация бизнес-процессов ИБ&nbsp;и&nbsp;их&nbsp;интеграция в&nbsp;систему управления организацией</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      SIEM
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Мониторинг и&nbsp;управление событиями ИБ&nbsp;в&nbsp;режиме реального времени</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      SOAR
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Интегрированная платформа оркестрации средств защиты&nbsp;информации и&nbsp;других функций ИБ</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      UDV ePlat4m
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Low-code платформа собственной разработки для&nbsp;автоматизации бизнес-процессов</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="main-nav__submenu-column">
                                        <span class="main-nav__submenu-list-title">защита физического периметра</span>
                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      ePerimeter
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Система автоматизации управления инженерно-техническими средствами охраны</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      ePass
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Единая автоматизированная система обеспечения пропускного режима</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="main-nav__item main-nav__item--submenu">
                <span class="main-nav__link main-nav__link--submenu">
                    сервисы
                    <span class="main-nav__link-icon">
                        <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="icon-chevron-down">

  <use xlink:href="#ai:local:icon-chevron-down"></use>

</svg>
                      </span>
                  </span>

                        <div class="main-nav__submenu" data-main-nav="submenu" data-scroll-lock-scrollable>
                            <div class="main-nav__submenu-wrap">
                                <div class="main-nav__submenu-header">
                                    <button type="button" class="main-nav__submenu-btn-back"
                                            data-main-nav="submenu-btn-back">
                          <span class="main-nav__submenu-btn-back-icon">
                            <svg width="1.34em" height="1em" viewBox="0 0 16 12" data-icon="icon-arrow-left">

  <use xlink:href="#ai:local:icon-arrow-left"></use>

</svg>
                          </span>
                                        <span class="main-nav__submenu-btn-back-text">сервисы</span>
                                    </button>
                                </div>
                                <div class="main-nav__submenu-list-wrap">
                                    <div class="main-nav__submenu-column">

                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      техническая поддержка
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Консультации, восстановление работы ПО, запросы на&nbsp;доработку</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      образовательные сервисы
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Курсы повышения квалификации по&nbsp;продуктам собственной разработки на&nbsp;базе Учебного Центра &laquo;АйТи Клауд&raquo;.</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="main-nav__item ">

                        <a class="main-nav__link" href="#" data-close-menu>
                            партнеры
                        </a>

                    </li>
                    <li class="main-nav__item main-nav__item--submenu">
                <span class="main-nav__link main-nav__link--submenu">
                    о нас
                    <span class="main-nav__link-icon">
                        <svg width="1em" height="1em" viewBox="0 0 18 18" data-icon="icon-chevron-down">

  <use xlink:href="#ai:local:icon-chevron-down"></use>

</svg>
                      </span>
                  </span>

                        <div class="main-nav__submenu" data-main-nav="submenu" data-scroll-lock-scrollable>
                            <div class="main-nav__submenu-wrap">
                                <div class="main-nav__submenu-header">
                                    <button type="button" class="main-nav__submenu-btn-back"
                                            data-main-nav="submenu-btn-back">
                          <span class="main-nav__submenu-btn-back-icon">
                            <svg width="1.34em" height="1em" viewBox="0 0 16 12" data-icon="icon-arrow-left">

  <use xlink:href="#ai:local:icon-arrow-left"></use>

</svg>
                          </span>
                                        <span class="main-nav__submenu-btn-back-text">о нас</span>
                                    </button>
                                </div>
                                <div class="main-nav__submenu-list-wrap">
                                    <div class="main-nav__submenu-column">

                                        <ul class="main-nav__submenu-list">
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      о группе компаний UDV
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Ключевая информация о компании</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      новости
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Все события и анонсы мероприятий</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      исследовательский центр
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Основные направления нашей работы</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      контакты
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Адреса и телефоны для связи</span>
                                                </a>
                                            </li>
                                            <li class="main-nav__submenu-item">
                                                <a class="main-nav__submenu-link" href="#" data-close-menu>
                                    <span class="main-nav__submenu-link-text">
                                      карьера в UDV Group
                                      <span class="main-nav__submenu-link-icon">
                                        <svg width="1em" height="1em" viewBox="0 0 20 20"
                                             data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
                                      </span>
                                    </span>
                                                    <span class="main-nav__submenu-link-description">Присоединяйтесь к нашей команде</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
                <div class="main-nav__btn-wrap">
                    <a href="#"
                       class="button button--outline button--size-m button--transparent main-nav__cta-btn"><span
                                class="button__text">связаться с нами</span><span class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">
  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></a>
                </div>
            </nav>
            <div class="header__btn-wrap">
                <a href="#write-to-us-form" class="button header__cta-btn"><span
                            class="button__text">связаться с нами</span><span class="button__icon">
        <svg width="1em" height="1em" viewBox="0 0 20 20" data-icon="icon-arrow-up-right">

  <use xlink:href="#ai:local:icon-arrow-up-right"></use>

</svg>
      </span></a>
            </div>
        </div>

    </div>
</header>

